import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;


public class MiniButton 
{
	private Rectangle box;
	private boolean active;
	private String name;
	private Color bgColor, txtColor;
	public MiniButton(String name, int x, int y, int width, int height){		
		box = new Rectangle(x,y,width,height);
		this.setName(name);
		setActive(true);
		this.setBgColor(Color.BLUE);
		this.setTxtColor(Color.YELLOW);
	}
	public boolean contains(int x, int y){
		return active && box.contains(x,y);
	}
	public boolean isActive() {
		return active;
	}
	public void setActive(boolean active) {
		this.active = active;
	}
	public void draw(Graphics g){
		if (!active)
			return;
		g.setColor(getBgColor());
		g.fillRect(box.x, box.y, box.width, box.height);
		g.setColor(txtColor);
		g.setFont(new Font("Helvetica", Font.BOLD, box.height/2));
		g.drawString(name, box.x+5, box.y+box.height-12);
		g.setColor(Color.BLACK);
		g.drawRect(box.x, box.y, box.width, box.height);
	}
	public Color getTxtColor() {
		return txtColor;
	}
	public void setTxtColor(Color txtColor) {
		this.txtColor = txtColor;
	}
	public Color getBgColor() {
		return bgColor;
	}
	public void setBgColor(Color bgColor) {
		this.bgColor = bgColor;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
}
